function PTVTL(input_files)
slevel=input_files(17:18); %pressEC-1k0-1k2-30-000-000.dat
%if slevel(1:1)==' '  slevel(1:1)='0'; end ;
ccf1 = input_files(9:11);
ccf2 = input_files(13:15);
cf1(1:1)=ccf1(1:1);cf1(2:2)=ccf1(3:3);cf1(3:4)='00';
cf2(1:1)=ccf2(1:1);cf2(2:2)=ccf2(3:3);cf2(3:4)='00';
if cf1(1:1)=='0' cf1(1:1)=''; end;
if cf2(1:1)=='0' cf2(1:1)=''; end;
infile=input_files;
[tt , pp1]=textread([infile '-000-000.dat'], '%f %f',24000,'headerlines',1);
[tt , pp2]=textread([infile '-017-033.dat'], '%f %f',24000,'headerlines',1);
[tt , pp3]=textread([infile '-033-067.dat'], '%f %f',24000,'headerlines',1);
[tt , pp4]=textread([infile '-050-100.dat'], '%f %f',24000,'headerlines',1);
[tt , pp5]=textread([infile '-067-133.dat'], '%f %f',24000,'headerlines',1);
[tt , pp6]=textread([infile '-083-167.dat'], '%f %f',24000,'headerlines',1);
[tt , pp7]=textread([infile '-100-000.dat'], '%f %f',24000,'headerlines',1);
[tt , pp8]=textread([infile '-117-033.dat'], '%f %f',24000,'headerlines',1);
[tt , pp9]=textread([infile '-133-067.dat'], '%f %f',24000,'headerlines',1);
[tt , ppA]=textread([infile '-150-100.dat'], '%f %f',24000,'headerlines',1);
[tt , ppB]=textread([infile '-167-133.dat'], '%f %f',24000,'headerlines',1);
[tt , ppC]=textread([infile '-183-167.dat'], '%f %f',24000,'headerlines',1);
ptot=pp1+pp2+pp3+pp4+pp5+pp6+pp7+pp8+pp9+ppA+ppB+ppC;
ptot=ptot/12;
dstt=  tt(1:4:23999);
dsp0= pp1(1:4:23999);
dspt=ptot(1:4:23999);
mp0=max(dsp0);
mp1=max(dspt);
envStim=mp0/2*(1-cos(pi()*((1:1000)-1)*0.001));
N=5000; Nm1=N-1;
sp90=findx4y(dstt(1:1000),envStim(1:1000),0.9*mp0,'pos');
sp50=findx4y(dstt(1:1000),envStim(1:1000),0.5*mp0,'pos');
sp10=findx4y(dstt(1:1000),envStim(1:1000),0.1*mp0,'pos');

[speak,xpeak,alpha,npeak] = peakpick ( dspt(1:4000), dstt(1:4000) ) ;
%mpR0=max(speak);
mpR0=mp1;
m90=0.9*mpR0; m50=0.5*mpR0; m10=0.1*mpR0;
xp90=findx4y(xpeak, speak, m90, 'pos');
xp50=findx4y(xpeak, speak, m50, 'pos');
xp10=findx4y(xpeak, speak, m10, 'pos');
delay90=xp90-sp90;
delay50=xp50-sp50;
delay10=xp10-sp10;

w=kaiser(N,4.0);
wpt=w.*dspt(1000:(1000+Nm1));
fwpt=fft(wpt);
%level : +correction reference pressure, 20 microPascal => +94.0 dB
%        +correction kaiser-bessel window; parameter=4  => +4.4 dB
%        -correction matlab definitie fft: N/2   => +6 dB, - 20.log10(N)
%       netto: factor 1/N in argument log10-term, and 104.4 dB corr
df=20;
fmax=2000*df;
ff=0:df:fmax ;
Lp0=20*log10(abs(fft(w.*dsp0(1000:(1000+Nm1))))/N) + 104.4;
Lp0max=max(Lp0);
Lp0min(1:N)=Lp0max-90;
Lp0=max(Lp0, Lp0min');

Lpt=20*log10(abs(fwpt)/N)+ 104.4;
[Lptmax imax]=max(Lpt);
fdist=ff(imax);
Lptmin(1:N)=Lptmax-90;
Lpt=max(Lpt, Lptmin');
phase=atan2(imag(fwpt(imax)),real(fwpt(imax)));

%% Create figure
figureT = figure('FileName',[infile '-time.fig'], ...
     'PaperType','A4','PaperOrientation','Portrait');
%% Create axes
axes1 = axes('Position',[0.13 0.60 0.775 0.3],'FontSize',16,'Parent',figureT);
txt1=sprintf('f_1 (%s Hz) + f_2 (%s Hz), both at %s dB; ear canal plugged',cf1,cf2,slevel);
title(axes1,txt1,'FontSize',16);
xlabel(axes1,'time (s)','FontSize',16);
ylabel(axes1,'p_{EC}  (mPa)','FontSize',16);
box(axes1,'on');
hold(axes1,'all');
%% Create plot
plot(dstt(1:4000),dsp0(1:4000)*1.e3,dstt(1:1000),envStim*1.e3,'Parent',axes1);
%legend({'stimulus'},'Position',[0.7535 0.8922 0.2 0.05]);
 
%% Create axes
axes2 = axes('Position',[0.13 0.15 0.775 0.3],'FontSize',16,'Parent',figureT);
txt2=sprintf('2f_1 - f_2 response in ear canal, delay50 = %5.2f ms',delay50*1.e3);
title(axes2,txt2,'FontSize',16);
xlabel(axes2,'time (s)','FontSize',16);
ylabel(axes2,'p_{EC}  (\mu Pa)','FontSize',16);
box(axes2,'on');
hold(axes2,'all');
%% Create plot
h2=plot(...
  dstt(1:4000),dspt(1:4000)*1.e6,'r',...
  xpeak,speak*1.e6,'g',...
  'Parent',axes2);
yas=get(axes2,'YLim');
xas=get(axes2,'XLim');
ymin=yas(1);
dy=abs(ymin/16);
xmax=xas(2);
dx=xmax/200;

plot(...
  [dstt(1) xp90 xp90 ], [m90*1.e6 m90*1.e6 ymin],'k',...
  [xp90-dx xp90 xp90+dx ], [ymin+dy ymin ymin+dy],'k',...
  [dstt(1) xp50 xp50 ], [m50*1.e6 m50*1.e6 ymin],'k',...
  [xp50-dx xp50 xp50+dx ], [ymin+dy ymin ymin+dy],'k',...
  [dstt(1) xp10 xp10 ], [m10*1.e6 m10*1.e6 ymin],'k',...
  [xp10-dx xp10 xp10+dx ], [ymin+dy ymin ymin+dy],'k',...
  'Parent',axes2);

%  'Color',[1 0 0],...
%% Create legend
%  dstt(1:(n1+999)),envResp*1.e6,...
%legend({'2f_1 - f_2'},'Position',[0.7535 0.4543 0.2 0.05]);
%% Create figure
figureQ = figure('FileName',[infile '-freq.fig'],'PaperSize',[20.98 29.68]);
%% Create axes
axes3 = axes('Position',[0.13 0.60 0.775 0.3],'FontSize',16,'Parent',figureQ);
txt3=sprintf('f_1 (%s Hz) + f_2 (%s Hz), both at %s dB; ear canal plugged',cf1,cf2,slevel);
title(axes3,txt3,'FontSize',16);
xlabel(axes3,'frequency (kHz)','FontSize',16);
ylabel(axes3,'L_{p_{EC}}  (dB)','FontSize',16);
box(axes3,'on');
hold(axes3,'all');
%% Create plot
plot(ff(1:400)/1000,Lp0(1:400),'Parent',axes3);
 
%% Create axes
axes4 = axes('Position',[0.13 0.15 0.775 0.3],'FontSize',16,'Parent',figureQ);
txt4=sprintf('2f_1 - f_2 response in ear canal');
title(axes4,txt4,'FontSize',16);
xlabel(axes4,'frequency (kHz)','FontSize',16);
ylabel(axes4,'L_{p_{EC}}  (dB)','FontSize',16);
box(axes4,'on');
hold(axes4,'all');
%% Create plot
plot(...
  ff(1:400)/1000,Lpt(1:400),...
  'Color',[1 0 0],...
  'Parent',axes4);
%% Create legend

%subplot(4,1,1),plot(dstt,dsp0);
%subplot(4,1,2),plot(dstt,dspt);
%subplot(4,1,3),plot(ff(1:256),Lpt(1:256));
%subplot(4,1,4),plot(ff(1:256),Lp0(1:256));
timefile= [dstt' ; dsp0' ; dspt'];
sfff=ff(1:2000); sfLp0=Lp0(1:2000); sfLpt=Lpt(1:2000);
specfile= [sfff ; sfLp0'; sfLpt'];
peakfile= [xpeak ; speak ];
if0=fopen([infile 'parm.dat'], 'w');
if1=fopen([infile 'time.dat'], 'w');
if2=fopen([infile 'freq.dat'], 'w');
fprintf(if0, 'Enkele berekede resultaten: \n','w');
fprintf(if0, 'delay90 = %12.8e s\n',delay90);
fprintf(if0, 'delay50 = %12.8e s\n',delay50);
fprintf(if0, 'delay10 = %12.8e s\n',delay10);
fprintf(if0, 'L_stim_max = %12.8e dB\n',Lp0max);
fprintf(if0, 'L_2f1-f2 (in fact: max distortion product) = %12.8e dB\n',Lptmax);
fprintf(if0, 'f_2f1-f2 (in fact: max distortion product) = %12.8e Hz\n',fdist);
fprintf(if0, 'fase_2f1-f2 = %12.8e rad\n',phase);
fprintf(if0, '%9.5e\t %12.8e\n',peakfile);

fprintf(if1, '    time\t stimulus   \t    2f2-f1\n','w');
fprintf(if1, '%9.5e\t %12.8e\t %12.8e\n', timefile );
fprintf(if2, '     freq\t stimulus   \t    2f2-f1\n','w');
fprintf(if2, '%10.6e\t %12.8e\t %12.8e\n',specfile);
fclose(if0); fclose(if1); fclose(if2);